extern crate sdl2;
//use std::path::Path;
use sdl2::event::Event;
use sdl2::keyboard::Keycode;
use sdl2::rect::Rect;
use sdl2::rect::Point;
use std::time::Duration;
use sdl2::image::{LoadTexture,InitFlag};
fn main() {
    let sdl_context = sdl2::init().unwrap();
    let video_subsystem = sdl_context.video().unwrap();

    let window = video_subsystem.window("SDL2", 640, 480)
        .position_centered().build().unwrap();

    let mut canvas = window.into_canvas()
        .accelerated().build().unwrap();
    let texture_creator = canvas.texture_creator();

    canvas.set_draw_color(sdl2::pixels::Color::RGBA(0,0,0,255));

    let mut timer = sdl_context.timer().unwrap();

    let mut event_pump = sdl_context.event_pump().unwrap();

    // animation sheet and extras are available from
    // https://opengameart.org/content/a-platformer-in-the-forest
    //let temp_surface = sdl2::surface::Surface::load_png(Path::new("assets/ojizousan.png")).unwrap();
    let _image_context = sdl2::image::init(InitFlag::PNG|InitFlag::JPG).unwrap();
    let png = "image.png";
    let png_marines ="image_marines.png";
    let png_bg="image_bg.png";
    let texture = texture_creator.load_texture(png).unwrap();
    let texture_marines = texture_creator.load_texture(png_marines).unwrap();
    let texture_bg = texture_creator.load_texture(png_bg).unwrap();

    let frames_per_anim = 4;
    let sprite_tile_size = (92,64);
    let sprite_tile_size_bg = (640,480);

    // Baby - walk animation
    let source_rect_6 = Rect::new(0, 0, sprite_tile_size_bg.0, sprite_tile_size_bg.0);
    let  dest_rect_6 = Rect::new(0, 0, sprite_tile_size_bg.0, sprite_tile_size_bg.0);
    let mut source_rect_0 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_0 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    dest_rect_0.center_on(Point::new(-64,220));
    let mut source_rect_1 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_1 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    dest_rect_1.center_on(Point::new(-64,220));
    // King - walk animation
    let mut source_rect_2 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_2 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    dest_rect_2.center_on(Point::new(-64,220));
    let mut source_rect_3 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_3 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    dest_rect_3.center_on(Point::new(-64,220));
    let mut source_rect_4 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_4 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    dest_rect_4.center_on(Point::new(-64,220));
    let mut source_rect_5 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_5 = Rect::new(0, 0, sprite_tile_size.0, sprite_tile_size.0);
    dest_rect_5.center_on(Point::new(-64,220));

/*
    // Soldier - walk animation
    let mut source_rect_2 = Rect::new(0, 64, sprite_tile_size.0, sprite_tile_size.0);
    let mut dest_rect_2 = Rect::new(0, 64, sprite_tile_size.0*4, sprite_tile_size.0*4);
    dest_rect_2.center_on(Point::new(440,360));
    */

    let mut running = true;
    while running {
        for event in event_pump.poll_iter() {
            match event {
                Event::Quit {..} | Event::KeyDown {keycode: Some(Keycode::Escape), ..} => {
                    running = false;
                },
                _ => {}
            }
        }

        let ticks = timer.ticks() as i32;

        // set the current frame for time
     source_rect_0.set_x(32 * ((ticks / 100) % frames_per_anim));
        source_rect_0.set_x(32 * ((ticks / 100) %1));
        dest_rect_0.set_x(1 * ((ticks / 14) % 768) - 100);
        source_rect_1.set_x(32 * ((ticks / 100) %1));
        dest_rect_1.set_x(1 * ((ticks / 14) % 768) - 200);
        source_rect_2.set_x(32 * ((ticks / 100) %1));
        dest_rect_2.set_x(1 * ((ticks / 14) % 768) - 300);
        source_rect_3.set_x(32 * ((ticks / 100) %1));
        dest_rect_3.set_x(1 * ((ticks / 14) % 768) - 400);
        source_rect_4.set_x(32 * ((ticks / 100) %1));
        dest_rect_4.set_x(1 * ((ticks / 14) % 768) - 500);
        source_rect_5.set_x(32 * ((ticks / 100) %1));
        dest_rect_5.set_x(1 * ((ticks / 14) % 768) - 600);
/*
        source_rect_1.set_x(32 * ((ticks / 100) % frames_per_anim));
        dest_rect_1.set_x((1 * ((ticks / 12) % 768) - 672) * -1);

        source_rect_2.set_x(32 * ((ticks / 100) % frames_per_anim));
        dest_rect_2.set_x(1 * ((ticks / 10) % 768) - 128);

        */
        canvas.clear();
        // copy the frame to the canvas
        canvas.copy_ex(&texture_bg, Some(source_rect_6), Some(dest_rect_6), 0.0, None, false, false).unwrap();
        canvas.copy_ex(&texture, Some(source_rect_0), Some(dest_rect_0), 0.0, None, false, false).unwrap();
        canvas.copy_ex(&texture, Some(source_rect_1), Some(dest_rect_1), 0.0, None, true, false).unwrap();
        canvas.copy_ex(&texture, Some(source_rect_2), Some(dest_rect_2), 0.0, None, false, false).unwrap();
        canvas.copy_ex(&texture, Some(source_rect_3), Some(dest_rect_3), 0.0, None, false, false).unwrap();
        canvas.copy_ex(&texture, Some(source_rect_4), Some(dest_rect_4), 0.0, None, false, false).unwrap();
        canvas.copy_ex(&texture_marines, Some(source_rect_5), Some(dest_rect_5), 0.0, None, false, false).unwrap();
        canvas.present();

        std::thread::sleep(Duration::from_millis(100));
    }
}
